#include "c8051F340.h"
#include <intrins.h>
#include <absacc.h>

#include <main.h>
#include <mmc_sd\mmc_sd.h>
#include <lcd\lcd.h>
//----------------------------------------------------------------------
void  SendDataSPI(unsigned char dat)
{  
   unsigned char i;
   
   for(i=0; i<8; i++)			
   {  
      if( (dat&0x80)!=0 ) SDA = 1;
        else SDA = 0;

      dat <<= 1;

	  SCL = 0;
      SCL = 1;			
   }
}

void WriteComm(unsigned int i)
{

    CS0 = 0;
	RS  = 0;

	SendDataSPI(i);

	CS0 = 1;

}
void WriteData(unsigned int i)
{
    CS0 = 0;
	RS  = 1;

	SendDataSPI(i);

	CS0 = 1;
}

void WriteDispData(unsigned char DataH,unsigned char DataL)
{
	 //CS0=0;

	 SendDataSPI(DataH);
	 SendDataSPI(DataL);

	 //CS0=1;
}

void LCD_Init(void)
{
	//CS0=0;
	
	RST=1;  
	Delay(200);
	
	RST=0;
	Delay(800);

	RST=1;
	Delay(1000);	
	             

	WriteComm(0x11);
	Delay(120);                

	WriteComm(0x36);     
	WriteData(0x00);   

	WriteComm(0x3A);     
	WriteData(0x55);   

	WriteComm(0xB2);     
	WriteData(0x0C);   
	WriteData(0x0C);   
	WriteData(0x00);   
	WriteData(0x33);   
	WriteData(0x33);   

	WriteComm(0xB7);     
	WriteData(0x75);   

	WriteComm(0xC2);     
	WriteData(0x01);   

	WriteComm(0xC3);     
	WriteData(0x19);  

	WriteComm(0xC4);     
	WriteData(0x20);  

	WriteComm(0xC6);     
	WriteData(0x0F);         	

	WriteComm(0xD0);     
	WriteData(0xA4);   
	WriteData(0xA1);   

	WriteComm(0xD6);     
	WriteData(0xA1);   

	WriteComm(0x21);     

	WriteComm(0xBB);     
	WriteData(0x3B);   

	WriteComm(0xE0);     
	WriteData(0xF0);   
	WriteData(0x0B);   
	WriteData(0x11);   
	WriteData(0x0E);   
	WriteData(0x0D);   
	WriteData(0x19);   
	WriteData(0x36);   
	WriteData(0x33);   
	WriteData(0x4B);   
	WriteData(0x07);   
	WriteData(0x14);   
	WriteData(0x14);   
	WriteData(0x2C);   
	WriteData(0x2E);   

	WriteComm(0xE1);     
	WriteData(0xF0);   
	WriteData(0x0D);   
	WriteData(0x12);   
	WriteData(0x0B);   
	WriteData(0x09);   
	WriteData(0x03);   
	WriteData(0x32);   
	WriteData(0x44);   
	WriteData(0x48);   
	WriteData(0x39);   
	WriteData(0x16);   
	WriteData(0x16);   
	WriteData(0x2D);   
	WriteData(0x30); 	    

	WriteComm(0x2A);  
	WriteData(0x00);   
	WriteData(0x00);  
	WriteData(0x00);   
	WriteData(0xEF); 

	WriteComm(0x2B);    
	WriteData(0x00);   
	WriteData(0x00); 
	WriteData(0x00);   
	WriteData(0xEF);

	WriteComm(0x29);              
                             
}

void BlockWrite(unsigned int Xstart,unsigned int Xend,unsigned int Ystart,unsigned int Yend) reentrant
{
	WriteComm(0x2A);             
	WriteData(Xstart>>8);             
	WriteData(Xstart);             
	WriteData(Xend>>8);             
	WriteData(Xend);             
	
	WriteComm(0x2B);             
	WriteData(Ystart>>8);             
	WriteData(Ystart);             
	WriteData(Yend>>8);             
	WriteData(Yend);   
	
	WriteComm(0x2c);	
}
void DispColor(unsigned int color)
{
	unsigned int i,j;
	 	CLKSEL = 0x03;
	BlockWrite(0,COL-1,0,ROW-1);

	CS0=0; 
	RS=1;
	//RD0=1;

	for(i=0;i<ROW;i++)
	{
	    for(j=0;j<COL;j++)
		{    
			SendDataSPI(color>>8);
			SendDataSPI(color);
		}
	}
		CLKSEL = 0x00;

	CS0=1; 
}