/**
  ******************************************************************************
  * @file    ST7565R.c
  * @author  
  * @version 
  * @date    
  * @brief   
  ******************************************************************************
  * @attention
  ******************************************************************************
  */	
/* Includes ------------------------------------------------------------------*/
#include "ST7565R.h"
#include "delay.h"

const unsigned char gImage[]={
0xFF,0x01,0x01,0x09,0xF9,0x09,0x01,0x01,0x09,0xF9,0x09,0xE1,0x11,0x09,0x09,0x09,
0x11,0xE1,0x01,0x19,0x09,0x09,0xF9,0x09,0x09,0x19,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x09,0xF9,0x09,0x09,0x09,0x11,0xE1,0x01,0x01,0x09,0x09,0xF9,0x09,
0x09,0x01,0x01,0x01,0x71,0x89,0x09,0x09,0x09,0x39,0x01,0x09,0xF9,0x09,0x09,0x09,
0x09,0xF1,0x01,0x01,0x01,0xC1,0x39,0xE1,0x01,0x01,0x01,0x09,0xF9,0x09,0x01,0x01,
0x01,0x01,0x01,0x09,0x39,0xC9,0x01,0xC9,0x39,0x09,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x09,0xF9,0x09,0x01,0x01,0x01,0x01,0x01,0xC1,0x31,0x09,0x09,0x09,
0x09,0x39,0x01,0x09,0xF9,0x09,0x09,0x09,0x11,0xE1,0x01,0x01,0x01,0x01,0x01,0xFF,
0xFF,0x00,0x00,0x20,0x3F,0x21,0x01,0x01,0x21,0x3F,0x20,0x0F,0x10,0x20,0x20,0x20,
0x10,0x0F,0x00,0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x20,0x3F,0x20,0x20,0x20,0x10,0x0F,0x00,0x00,0x20,0x20,0x3F,0x20,
0x20,0x00,0x00,0x00,0x38,0x20,0x21,0x21,0x22,0x1C,0x00,0x20,0x3F,0x21,0x01,0x01,
0x01,0x00,0x00,0x20,0x3C,0x23,0x02,0x02,0x27,0x38,0x20,0x20,0x3F,0x20,0x20,0x20,
0x20,0x30,0x00,0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x20,0x3F,0x20,0x20,0x20,0x20,0x30,0x00,0x07,0x18,0x20,0x20,0x20,
0x10,0x08,0x00,0x20,0x3F,0x20,0x20,0x20,0x10,0x0F,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0xF8,0x08,0x00,0x00,0x08,0xF8,0x08,
0x18,0x08,0x08,0xF8,0x08,0x08,0x18,0x00,0x08,0xF8,0xF8,0x00,0xF8,0xF8,0x08,0x00,
0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,
0x00,0x70,0x88,0x08,0x08,0x88,0x70,0x00,0x00,0xE0,0x10,0x88,0x88,0x18,0x00,0x00,
0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x3F,0x21,0x01,0x01,0x21,0x3F,0x20,
0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,0x20,0x3F,0x00,0x3F,0x00,0x3F,0x20,0x00,
0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,0x00,0x30,0x28,0x24,0x22,0x21,0x30,0x00,
0x00,0x1C,0x22,0x21,0x21,0x22,0x1C,0x00,0x00,0x0F,0x11,0x20,0x20,0x11,0x0E,0x00,
0x00,0x07,0x04,0x24,0x24,0x3F,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x08,0xF8,0x08,0x08,0x08,0x10,0xE0,0x00,0xE0,0x10,0x08,0x08,0x08,0x10,0xE0,0x00,
0x18,0x08,0x08,0xF8,0x08,0x08,0x18,0x00,0x00,0x70,0x88,0x08,0x08,0x08,0x38,0x00,
0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,
0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x70,0x88,0x08,0x08,0x88,0x70,0x00,
0x00,0x80,0x80,0x00,0x80,0x80,0x80,0x00,0x00,0xE0,0x10,0x88,0x88,0x18,0x00,0x00,
0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x20,0x3F,0x20,0x20,0x20,0x10,0x0F,0x00,0x0F,0x10,0x20,0x20,0x20,0x10,0x0F,0x00,
0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,0x00,0x38,0x20,0x21,0x21,0x22,0x1C,0x00,
0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,
0x00,0x30,0x28,0x24,0x22,0x21,0x30,0x00,0x00,0x1C,0x22,0x21,0x21,0x22,0x1C,0x00,
0x00,0x20,0x31,0x2E,0x0E,0x31,0x20,0x00,0x00,0x0F,0x11,0x20,0x20,0x11,0x0E,0x00,
0x00,0x07,0x04,0x24,0x24,0x3F,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,
0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x30,0x08,0x88,0x88,0x48,0x30,0x00,
0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0xF8,0x08,0x88,0x88,0x08,0x08,0x00,
0x00,0xE0,0x10,0x88,0x88,0x18,0x00,0x00,0x00,0x38,0x08,0x08,0xC8,0x38,0x08,0x00,
0x00,0x70,0x88,0x08,0x08,0x88,0x70,0x00,0x00,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,
0x00,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,
0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x30,0x08,0x88,0x88,0x48,0x30,0x00,
0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0xF8,0x08,0x88,0x88,0x08,0x08,0xFF,
0xFF,0x8F,0x90,0xA0,0xA0,0x90,0x8F,0x80,0x80,0xA0,0xA0,0xBF,0xA0,0xA0,0x80,0x80,
0x80,0xB0,0xA8,0xA4,0xA2,0xA1,0xB0,0x80,0x80,0x98,0xA0,0xA0,0xA0,0x91,0x8E,0x80,
0x80,0x87,0x84,0xA4,0xA4,0xBF,0xA4,0x80,0x80,0x99,0xA1,0xA0,0xA0,0x91,0x8E,0x80,
0x80,0x8F,0x91,0xA0,0xA0,0x91,0x8E,0x80,0x80,0x80,0x80,0xBF,0x80,0x80,0x80,0x80,
0x80,0x9C,0xA2,0xA1,0xA1,0xA2,0x9C,0x80,0x80,0x80,0xB1,0xA2,0xA2,0x91,0x8F,0x80,
0x80,0x8F,0x90,0xA0,0xA0,0x90,0x8F,0x80,0x80,0xA0,0xA0,0xBF,0xA0,0xA0,0x80,0x80,
0x80,0xB0,0xA8,0xA4,0xA2,0xA1,0xB0,0x80,0x80,0x98,0xA0,0xA0,0xA0,0x91,0x8E,0x80,
0x80,0x87,0x84,0xA4,0xA4,0xBF,0xA4,0x80,0x80,0x99,0xA1,0xA0,0xA0,0x91,0x8E,0xFF
};

const unsigned char gImage1[]={
0x00,0x04,0xFC,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0xA0,0xA0,0xA0,0xA0,0xC0,
0x00,0x00,0x00,0xC0,0x40,0x20,0x20,0x44,0xFC,0x00,0x00,0x00,0x00,0x20,0x20,0xE4,
0x00,0x00,0x00,0x00,0x00,0xC0,0x40,0x20,0x20,0x20,0x40,0xC0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x84,0x84,0x84,0x44,0xF8,0x00,0x00,
0x00,0x08,0x04,0x04,0x84,0x44,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xF0,0x88,0x44,0x44,0x44,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x04,0xFC,0x30,0xC0,0x00,0xC0,0x30,0xFC,0x04,0x04,0xFC,0x44,0x40,
0x40,0x40,0x44,0xFC,0x04,0x00,0x60,0x20,0x20,0x20,0xA0,0x60,0x20,0x00,0x00,0x00,
0x40,0x48,0x4F,0x48,0x40,0x41,0x42,0x4C,0x48,0x40,0x47,0x48,0x48,0x48,0x48,0x47,
0x48,0x40,0x40,0x47,0x44,0x48,0x48,0x44,0x4F,0x48,0x40,0x40,0x40,0x48,0x48,0x4F,
0x48,0x48,0x40,0x40,0x40,0x47,0x44,0x48,0x48,0x48,0x44,0x47,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x48,0x48,0x48,0x44,0x43,0x40,0x40,
0x40,0x4C,0x4A,0x49,0x48,0x48,0x48,0x40,0x40,0x40,0x40,0x40,0x4C,0x4C,0x40,0x40,
0x40,0x40,0x40,0x47,0x48,0x48,0x48,0x48,0x47,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x48,0x4F,0x48,0x40,0x43,0x40,0x48,0x4F,0x48,0x48,0x4F,0x48,0x40,
0x40,0x40,0x48,0x4F,0x48,0x40,0x48,0x4C,0x4A,0x49,0x48,0x48,0x4C,0x40,0x40,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,
0xE0,0xFC,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0xFC,0xE0,0xE0,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0xE0,0xFC,0x1C,0x1C,0x1C,0x1C,
0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0xFC,0xE0,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xE0,0xE0,0xE0,0xFC,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
0x1C,0x1C,0x1C,0xFC,0xE0,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,
0x00,0x00,0x80,0x40,0x20,0x10,0x00,0x00,0x80,0x00,0x80,0x80,0x80,0x00,0x00,0x80,
0x80,0x80,0x00,0x00,0x00,0x00,0xC0,0x30,0x00,0xF0,0x00,0x80,0x80,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,
0x1F,0xFF,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xFF,0x1F,0x1F,
0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,0xFF,0xE0,0xE0,0xE0,0xE0,
0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xFF,0x1F,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,0xFF,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,
0xE0,0xE0,0xE0,0xFF,0x1F,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x08,0x04,
0x02,0x07,0x08,0x30,0x40,0x80,0x00,0x00,0xFF,0x01,0x00,0x00,0x00,0xFF,0x01,0x00,
0x00,0x00,0xFF,0x00,0xC0,0x3C,0x03,0x00,0x00,0xFF,0x01,0x00,0x00,0x00,0xFF,0x00,
0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,
0x04,0x04,0x84,0x84,0xC4,0x04,0x04,0x04,0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,
0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x84,0x84,0xC4,0x04,0x04,0x04,
0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,
0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x84,0x84,0xC4,0x04,0x04,0x04,
0x04,0x04,0xC4,0x44,0x44,0x44,0x44,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
0x04,0x84,0x44,0x44,0x44,0x84,0x04,0x04,0x04,0xC4,0x44,0x44,0x44,0x44,0x04,0x04,
0x00,0x00,0x60,0x50,0x48,0x44,0x43,0x00,0x00,0x00,0x3F,0x40,0x40,0x40,0x3F,0x00,
0x00,0x00,0x40,0x40,0x7F,0x40,0x40,0x00,0x00,0x00,0x3F,0x40,0x40,0x40,0x3F,0x00,
0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x40,0x40,0x7F,0x40,0x40,0x00,
0x00,0x00,0x60,0x50,0x48,0x44,0x43,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
0x00,0x00,0x20,0x40,0x44,0x44,0x3B,0x00,0x00,0x00,0x3F,0x40,0x40,0x40,0x3F,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x7F,0x40,0x40,0x00,
0x00,0x00,0x27,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00,0x21,0x00,0x00,0x00,
0x00,0x60,0x50,0x48,0x44,0x43,0x00,0x00,0x00,0x27,0x44,0x44,0x44,0x38,0x00,0x00,
};

/* extern variables ----------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/
void ST7565R_Nop_Delay(unsigned char ucDat);
/**
  * @brief  Write ST7565R 1 Command
  * @param  None 
  * @retval None
  */



void LCD_WriteLByte(unsigned char LCD_DATA)//дPCڵĵ8λ8λ
{
	
//	GPIO_Write(GPIOF,((GPIOF->ODR&0xFF00) |(LCD_DATA&0x00FF)));
//	LCD_Write(LCD_DATA);	
//  u16 Data_PAL;
//  Data_PAL = GPIO_ReadOutputData(GPIOF);
//  Data_PAL = Data_PAL&0xFF00;//8λ
//  Data_PAL = Data_PAL | Byte;//д8λ
//  GPIO_Write(GPIOF,Data_PAL );
}


void ST7565R_Comwrite(unsigned char com)
{	
  

  A0_0;
  CS_0;
  RD_1;
  WR_0;
  GPIO_Write(GPIOF,com);
  WR_1;
  CS_1;
}

void ST7565R_Datawrite(unsigned char dat)
{   	
 
	
  A0_1;
  CS_0;
  RD_1;
  WR_0;
  GPIO_Write(GPIOF,dat);
  WR_1;	
  CS_1;	
}
/**
  * @brief  Configures ht16xx GPIO.
  * @param  None 
  * @retval None
  */
void ST7565R_Lowlevel_Init(void)
{
	
	
	GPIO_InitTypeDef  GPIO_InitStructure;
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOF|RCC_APB2Periph_GPIOC,ENABLE);	
	
	GPIO_InitStructure.GPIO_Pin=GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2| GPIO_Pin_3 |GPIO_Pin_4;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
		
	GPIO_Init(GPIOC,&GPIO_InitStructure);
	GPIO_SetBits(GPIOC,GPIO_Pin_0|GPIO_Pin_1|GPIO_Pin_2|GPIO_Pin_3|GPIO_Pin_4);	//PC0~PC4 
	
	GPIO_InitStructure.GPIO_Pin =GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2| GPIO_Pin_3 |GPIO_Pin_4|GPIO_Pin_5 | GPIO_Pin_6 | GPIO_Pin_7;
 	GPIO_Init(GPIOF, &GPIO_InitStructure);
 //	GPIO_SetBits(GPIOF,0xFF); //PF0~7
		
	
		

}
/**
  * @brief  ST7565R Init
  * @param  None 
  * @retval None
  */
void ST7565R_Init(void)
{	
	
	
	RES_0 ; delay_ms(10);
	RES_1 ; delay_ms(10);
    delay_ms(100);
	ST7565R_Comwrite(0xe3);
	ST7565R_Comwrite(0xA2);	//1010001/BS  duty:1/65,BS-1:1/7,0:1/9
	ST7565R_Comwrite(0xA0);	//Sets the display RAM address SEG output correspondence  0: normal, 1: reverse 
	ST7565R_Comwrite(0xc8);	//com direction  Normal direction
	ST7565R_Comwrite(0x2c);
	ST7565R_Comwrite(0x2e);
	ST7565R_Comwrite(0x2F);//power on :00101/Booster circuit/Voltage regulator circuit/Voltage follower circuit
	ST7565R_Comwrite(0xf8);//Booster Ratio Select Mode Set
	ST7565R_Comwrite(0x00);
	ST7565R_Comwrite(0x81);	//SET EV :10000001
	ST7565R_Comwrite(0x18);//Setting V0 Voltage:(0x00~0x3f)	 Contrast settings
	ST7565R_Comwrite(0x25);//regulation ration: (0x21~0x27)	 Contrast settings
	ST7565R_Comwrite(0xAF);	//Display ON/OFF :1010111/D  on:1
	ST7565R_Comwrite(0x40);	//Set Start Line
	delay_ms(10);				


}
/**
  * @brief  Inserts a delay time.
  * @param  None 
  * @retval None
  */

void Display(unsigned char sda,unsigned char sda1)
{
  unsigned char i,j,k=0; 
  ST7565R_Comwrite(0x40);
  for(i=0;i<8;i++)
	{
	ST7565R_Comwrite(0XB0+k);
	ST7565R_Comwrite(0x10);
	ST7565R_Comwrite(0x00);	
	for(j=0;j<66;j++)
	   {
		ST7565R_Datawrite(sda);
	    ST7565R_Datawrite(sda1);
	   }
	   k++;
	}
	
}   


void gImage_Display(void)
{
  unsigned char   i,j,k=0;
  ST7565R_Comwrite(0x40);
      for(i=0;i<8;i++)
	{
	  
	ST7565R_Comwrite(0XB0+k);
	ST7565R_Comwrite(0x10);
	ST7565R_Comwrite(0x00);	
      for(j=0;j<128;j++)	
	  {ST7565R_Datawrite(gImage1[i*128+j]);}	
	  k++; 
	} 
   delay_ms(300);  		   	  	 
}     

void ST7565R_Test(void)
{
	
	
	ST7565R_Init();
	while(1)
	{		
	
		Display(0xFF,0x00);delay_ms(300);
		Display(0x00,0xFF);delay_ms(300);
		Display(0x55,0xAA);delay_ms(300);
		Display(0xAA,0x55);delay_ms(300);
		gImage_Display();delay_ms(300);

	}
}
/**
  * @brief  Inserts a delay time.
  * @param  None 
  * @retval None
  */
void ST7565R_Nop_Delay(unsigned char ucDat)
{
	while(ucDat--) 
	{
		__NOP(); __nop();__NOP(); __nop();
		__NOP(); __nop();__NOP(); __nop();//160khz
	}
}
/************************END OF FILE****/
